
/*============================================================================
 Name        : main.c
 Author      : atao
 Version     : Demo V2.0.A.1_20151020
 Copyright   : ZKSoftware Inc.
 Description : main in Linux C
 ============================================================================*/
#include "serial.h"
#include "libtype.h"
#include "command_fun.h"
#include "libuserCmd.h"
#include "main.h"
#include "usb.h"
#include "zkfpi.h"

WINDOW *win, *win1, *win2;
INT Dev_num = 1;	//dev:usb or ff232

int main(int argv, char *argc[])
{
	int exit_flag = 0;
	int reset_flag = -1;
	int ret = 0;
	int flag = 0;
	int value = 0;
	int i = 0;
	int index = 1;
	int Year = 0;
	int Month = 0;
	int Day = 0;
	int Hour = 0;
	int Minute = 0;
	int Second = 0;
	int num = 0;
	int width = 0;
	int height = 0;
	int userID = 0;
	char event = 0;
	char verified = 0;
	char *reserved = NULL;
	char name[8];
	char password[5];
	char filename[DIRSIZE];
	static char Device[15] = {"\0"};
	char devName[7] = {"\0"};
	U8 privilege = '\0';
	U8 fingerprintNum = '\0';
	U8 Card[5];
	U8 *data = NULL;
	U8 lamp_time = 0;
	U8 lamp_type = 0;
	U16 secLevel = 0;
	U32 PIN2 = 0;
	U32 date = 0;
	U32 time = 0;
	U32 fsize = 0;

	while(1)
	{
		/****************** INIT *******************/
		CursesInit();

		WinBox();
		//dev select.  usb or 232 ?
		mvwprintw(win, 7, 24, "Welcome to use ZK_Silk20 Demo!");
		mvwprintw(win, 10, 20, "Please select dev[0-usb or 1-ff232]:");
		mvwscanw(win, 10, 56, "%d", &Dev_num);
		fflush(stdin);

		DebugFile_init();
		if(Dev_num == DEV_232)
		{
			mvwprintw(win, 10, 41, "                      ");
			memset(Device, 0, sizeof(Device));
			memset(devName, 0, sizeof(devName));
			mvwprintw(win, 10, 20, "Please input devName--[ttyS0]:");
			mvwscanw(win, 10, 50, "%s", devName);
			fflush(stdin);
			devName[6] = '\0';
			sprintf(Device, "/dev/%s", devName);
		}
		wclear(win);
		//usb & 232
		ret = Connect(Device, Dev_num);

		if(ret == SUCCESS)
		{
			mvwprintw(win1, 2, 1, "Connect OK!");
		}
		else if(ret == FAILURE)
		{
			mvwprintw(win1, 2, 1, "Connect err!");
		}
		fclose(Fp);
		Fp = NULL;
		/***************** Exe UserCmd ******************/

		while(1)
		{
			DebugFile_init();
			exit_flag = 0;
			WinBox();
			PrintInfo();
			mvwprintw(win, 18, 2, "Please select:_");
			wclrtoeol(win);
			wclear(win1);
			if(mvwscanw(win, 18, 16, "%d", &num) != 1)
			{
				WinBox();
				mvwprintw(win1, 1, 1, "Input num err...");
				CloseWin();
				return FALSE;
			}
			fflush(stdin);
			wrefresh(win);
			if(Dev_num == DEV_USB)
			{
				Recv_data();
			}
			switch(num)
			{
				case 1:
					input_info(&userID);
					mvwprintw(win1, 1, 1, "Please press figerprint!(3 times) >>>");
					DebugWin(win1, 0);
					ret = EnrollUserByScan(userID);
					break;
				case 2:
					input_info(&userID);
					mvwprintw(win1, 1, 1, "Please press figerprint! >>>");
					DebugWin(win1, 1);
					mvwprintw(win1, 1, 1, "Please wait a moment, data is recving ...");
					DebugWin(win1, 0);
					data = zk_malloc(IMAGE_SIZE);
					if(GetFingerImage(&width, &height, data))
					{
						save_bmp(data, width, height);
						mvwprintw(win1, 1, 1, "Please wait a moment, data is sending ...");
						DebugWin(win1, 0);
						ret = EnrollTemplateByImage(userID, data, width * height);
					}
					if(data != NULL)
					{
						zk_free(data);
						data = NULL;
					}
					break;
				case 3:
					mvwprintw(win1, 1, 1, "Please press figerprint! >>>");
					DebugWin(win1, 1);
					mvwprintw(win1, 1, 1, "Please wait a moment, data is recving ...");
					DebugWin(win1, 0);
					data = zk_malloc(IMAGE_SIZE);
					if((ret = GetFingerImage(&width, &height, data)))
					{
						save_bmp(data, width, height);
					}
					if(data != NULL)
					{
						zk_free(data);
						data = NULL;
					}
					break;
				case 4:
					data = zk_malloc(IMAGE_SIZE);
					mvwprintw(win1, 1, 1, "Please press figerprint! >>>");
					DebugWin(win1, 1);
					mvwprintw(win1, 1, 1, "Please wait a moment, data is recving ...");
					DebugWin(win1, 0);
					if(GetFingerImage(&width, &height, data))
					{
						mvwprintw(win1, 1, 1, "Please wait a moment, data is sending ...");
						DebugWin(win1, 0);
						if((ret = IdentifyByImage(width * height, &userID, &index, data)))
						{
							mvwprintw(win1, 2, 1, "userID: %d\tindex: %d", userID, index);
							fprintf(Fp, "userID: %d\tindex: %d\r\n", userID, index);
						}
						else
						{
							mvwprintw(win1, 2, 1, "User not exist!");
						}
					}
					if(data != NULL)
					{
						zk_free(data);
						data = NULL;
					}
					break;
				case 5:
					input_info(&userID);
					mvwprintw(win1, 1, 1, "Please press finger >>> ");
					DebugWin(win1, 0);
					ret = Verify(userID);
					break;
				case 6:
					ret = DeleteAllLogs();
					break;
				case 7:
					ret = ClearDB();
					break;
				case 8:
					touchwin(win2);
					i = 0;
					mvwprintw(win2, 1, 1, "USERID EVENT VERIFIED DATE\t  TIME     RESERVED");
					reserved = zk_malloc(4);
					while(1)
					{
						if(i == 14)
						{
							mvwprintw(win2, 2 + i, WIN_COL - 15, "[More]...>>>");
							i = 0;
						}
						if(ReadAllLogs(&userID,  &event, &verified,	&date, &time, reserved))
						{
							TimeAnalyse(date, time, &Year, &Month, &Day,  &Hour, &Minute, &Second);
							mvwprintw(win2, 2 + i, 1, "%-7d%-6d%-9d%-4d/%-2d/%-2d %-2d:%-2d:%-3d%s",
									userID, event, verified,
									Year + 2000, Month, Day, Hour, Minute, Second, reserved);
							i++;
						}
						else
						{
							break;
						}
					}
					wrefresh(win2);
					wclear(win2);
					zk_free(reserved);
					reserved = NULL;
					WL_FILE();//write logs file
					break;
				case 9:
					mvwprintw(win, 18, 2, "Please input DATA[Y/M/D h:m:s]:");
					wclrtoeol(win);
					mvwscanw(win, 18, 33, "%d/%d/%d %d:%d:%d", &Year, &Month, &Day, &Hour, &Minute, &Second);
					fflush(stdin);
					ret = SetTime(Year, Month, Day, Hour, Minute, Second);
					break;
				case 10:
					ret = GetTime(&Year, &Month, &Day,  &Hour, &Minute, &Second);
					mvwprintw(win2, 5, 25, "SlikID Data: %d/%d/%d %d:%d:%d",
								Year + 2000, Month, Day, Hour, Minute, Second);
					touchwin(win2);
					wrefresh(win2);
					wclear(win2);
					break;
				case 11:
					ret = GetStatus();
					if(ret)
					{
						mvwprintw(win1, 2, 1, "SystemStatus: Busy!");
					}
					break;
				case 12:
					mvwprintw(win1, 1, 1, "[Info]:flag{0x31,0x36,0x50,0x62,0x6D,0x6E,0x71}");
					mvwprintw(win1, 2, 1, "[Info]:flag{0x73,0x74,0x79,0x7b,0x7C,0x82,0x89}");
					DebugWin(win1, 3);
					mvwprintw(win, 18, 2, "Please input flag[0x??]:");
					wclrtoeol(win);
					mvwscanw(win, 18, 26, "%p", &flag);
					fflush(stdin);
					ret = GetParameter(flag, &value);
					mvwprintw(win1, 2, 1, "Parameter = 0x%02x", value);
					break;
				case 13:
					while(1)
					{
						mvwprintw(win1, 1, 1, "[Info]:flag{0x31,0x36,0x50,0x62,0x6D,0x82}");
						DebugWin(win1, 3);
						mvwprintw(win, 18, 2, "Please input flag[0x??]:");
						wclrtoeol(win);
						mvwscanw(win, 18, 26, "%p", &flag);
						fflush(stdin);
						if((flag == SID_MODULE_ID) || (flag == SID_SAVE_LOG) ||	(flag == SID_AUTO_ACK) ||
								(flag == SID_TIMEOUT) || (flag == SID_MODULE_IDENTIFY) || (flag == SID_GPIO_LEVEL))
						{
							break;
						}
						else
						{
							mvwprintw(win1, 1, 1, "[Debug]:Parameter not to write");
							DebugWin(win1, 1);
						}
					}
					if(flag == SID_GPIO_LEVEL)
					{
						mvwprintw(win1, 1, 1, "[Info]:lamp_time{0x31->1s ... 0x3a->10s ... 0x44->20s}");
						DebugWin(win1, 3);
						mvwprintw(win, 18, 2, "Please input lamp timeout[0x??]:");
						wclrtoeol(win);
						mvwscanw(win, 18, 34, "%p", &lamp_time);
						fflush(stdin);
						mvwprintw(win1, 1, 1, "[Info]:lamp_type{0x80->Green,0x40->Red,0xC0->Yellow}");
						DebugWin(win1, 3);
						mvwprintw(win, 18, 2, "Please input lamp type[0x??]:");
						wclrtoeol(win);
						mvwscanw(win, 18, 31, "%p", &lamp_type);
						fflush(stdin);
						value = lamp_type & 0xffff;
						value <<= 8;
						value = lamp_time & 0xffff;
					}
					else
					{
						mvwprintw(win, 18, 2, "Please input Parameter values[0x??]:");
						wclrtoeol(win);
						mvwscanw(win, 18, 38, "%p", &value);
						fflush(stdin);
					}
					ret = SetParameter(value, flag);
					break;
				case 14:
					ret = SaveParameter();
					break;
				case 15:
					ret = DeleteAllUsers();
					break;
				case 16:
					input_info(&userID);
					ret = DeleteUser(userID);
					break;
				case 17:
					i = 0;
					mvwprintw(win2, 1, 1, "USERID NAME  PASSWORD SECLEVEL PRIVILEGE FIGERPRINTNUM  PIN2\t\tCARD");
					while(1)
					{
						if(14 == i)
						{
							mvwprintw(win2, 2 + i, WIN_COL - 15, "[More]...>>>");
							i = 0;
						}
						if(ReadAllUser(&userID, name, password, &secLevel, &PIN2, &privilege, &fingerprintNum, Card))
						{
							mvwprintw(win2, 2 + i, 1, "%-7d%-6s%-9s%-9d%-10x%-15hhu%-14ld%5s",userID,
								name, password, secLevel, privilege, fingerprintNum, PIN2, Card);
							i++;
						}
						else
						{
							ret = 1;
							break;
						}
					}
					touchwin(win2);
					wrefresh(win2);
					werase(win2);
					WU_FILE();//wirte user file
					break;
				case 18:
					input_info(&userID);
					if((ret = GetUser(userID, name, password, &secLevel, &PIN2, &privilege, &fingerprintNum, Card)))
					{
						mvwprintw(win2, 1, 1, "userID name  password secLevel privilege figerprintNum  PIN2\t\tCard");
						mvwprintw(win2, 2, 1, "%-7d%-6s%-12s%-9d%x\t\t%hhu\t %ld\t\t%5s",userID,
								name, password, secLevel, privilege, fingerprintNum, PIN2, Card);
					}
					touchwin(win2);
					wrefresh(win2);
					wclear(win2);
					break;
				case 19:
					memset(Card, 0, sizeof(Card));
					new_user(&userID, name, password, Card);
					ret = ModifyUser(userID, name, password, 0, userID, 0, 0, Card);
					break;
				case 20:
					input_info(&userID);
					mvwprintw(win, 18, 2, "Please input flag[0 or 1]:");
					wclrtoeol(win);
					mvwscanw(win, 18, 28, "%d", &flag);
					fflush(stdin);
					mvwprintw(win, 18, 2, "Please input filename:");
					wclrtoeol(win);
					memset(filename, 0, sizeof(filename));
					mvwscanw(win, 18, 24, "%s", filename);
					fflush(stdin);
					data = zk_malloc(TEMPLATES_SIZE);
					if((ret = RT_FILE(data, filename)))
					{
						ret = SetTemplates(userID, flag, data, TEMPLATES_SIZE);
					}
					if(data != NULL)
					{
						zk_free(data);
						data = NULL;
					}
					break;
				case 21:
					input_info(&userID);
					mvwprintw(win, 18, 2, "Please input index(0~9):");
					wclrtoeol(win);
					mvwscanw(win, 18, 26, "%d", &index);
					fflush(stdin);
					mvwprintw(win, 18, 2, "Please input flag[0 or 1]:");
					wclrtoeol(win);
					mvwscanw(win, 18, 28, "%d", &flag);
					fflush(stdin);
					ret = DeleteTemplates(userID, index, flag);
					break;
				case 22:
					ret = DeleteAllTemplates();
					break;
				case 23:
					WT_FILE(0);//write templates file
					break;
				case 24:
					WT_FILE(1);//write templates file
					break;
				case 25:
					if(SetParameter(0x31, 0x50))
					{
						mvwprintw(win1, 1, 1, "Please press finger >>> ");
						DebugWin(win1, 5);
						data = zk_malloc(TEMPLATES_SIZE);
						ret = ScanTemplate(data);
						SetParameter(0x30, 0x50);
					}
					if(data != NULL)
					{
						zk_free(data);
						data = NULL;
					}
					break;
				case 26:
					ret = EnableDevice();
					break;
				case 27:
					ret = DisableDevice();
					break;
				case 28:
					ret = Reset();
					break;
				case 29:
					data = zk_malloc(FIRMWARE_SIZE);
					memset(filename, 0, sizeof(DIRSIZE));
					sprintf(filename, "./%s", FIRMWARE);
					if((fsize = Read_FILE(data, filename)))
					{
						fprintf(Fp, "Is upgrading...\r\n");
						mvwprintw(win1, 1, 1, "[Debug]:Is upgrading...");
						DebugWin(win1, 0);
						ret = Upgrade(data, fsize);
					}
					if(data != NULL)
					{
						zk_free(data);
						data = NULL;
					}
					break;
				case 66:
					if((ret = Disconnect()))
					{
						exit_flag = 1;
						reset_flag = 1;
					}
					break;
				case 77:
					ret = version();
					break;
				case 88:
					ret = ViewData();
					break;
				case 99:
					if(AutoDubug())
					{
						ret = 1;
						fprintf(Fp, "All Option...OK!\r\n");
						mvwprintw(win1, 1, 1, "All Option...OK!");
						DebugWin(win1, 2);
					}
					else
					{
						ret = 0;
						fprintf(Fp, "Err:Debug interrupt!\r\n");
						mvwprintw(win1, 1, 1, "Err:Debug interrupt!");
						DebugWin(win1, 2);
					}
					break;
				case 0:
					ret = Disconnect();
					ret = 1;
					exit_flag = 1;
					reset_flag = 0;
					break;
				default:
					mvwprintw(win1, 1, 1, "Select err...");
					continue;
			}
			if(ret)
			{
				mvwprintw(win1, 1, 1, "Operation is successful!");
			}
			else
			{
				DisplayFail(Err_flag);
				mvwprintw(win1, 1, 1, "Operation failure...");
			}
			DebugWin(win1, 2);
			fclose(Fp);
			Fp = NULL;
			mvwprintw(win1, 1, 1, "Press any key to continue!");
			wclrtoeol(win);
			DebugWin(win1, 0);
			if(exit_flag)
			{
				break;
			}
			mvgetch(19, 8);
			touchwin(win);
		}

		/******************** Close *********************/
		CloseWin();
		if(reset_flag == 0)
		{
			break;
		}
	}
	return TRUE;
}

/********************* User file *************************/
INT WU_FILE(VOID)
{
	FILE *fp = NULL;
	CHAR filename[DIRSIZE];
	CHAR curPath[DIRSIZE];
	tUser user;

	memset(curPath, 0, sizeof(curPath));
	//open path
	if(!Write_file('u', curPath))
	{
		return FAILURE;
	}
	//Output to file
	while(1)
	{
		if(ReadAllUser(((int *)(&user.userID)), user.Name, user.Password, &user.SecLevel,\
				&user.PIN2, &user.Privilege, &user.Fpnum, user.Card))
		{
			memset(filename, 0, sizeof(filename));
			sprintf(filename, "%d", user.userID);
			if(NULL == (fp = fopen(filename, "wb")))
			{
				mvwprintw(win1, 1, 1, "new file err...%s:%d:%s", __FILE__, __LINE__,  __func__);
				DebugWin(win1, 2);
				return FAILURE;
			}
			fwrite(&user, sizeof(tUser), 1, fp);
			fclose(fp);
			fp = NULL;
		}
		else
		{
			break;
		}
	}
	mvwprintw(win1, 1, 1, "User File write OK!");
	DebugWin(win1, 2);
	fprintf(Fp, "[17]User File write.....OK!\r\n");
	if(chdir(curPath))
	{
		mvwprintw(win1, 1, 1, "chdir err...%s:%d:%s", __FILE__, __LINE__,  __func__);
		DebugWin(win1, 2);
		return FAILURE;
	}
	return SUCCESS;
}

INT WT_FILE(INT model)
{
	INT userID = 0;
	INT index = 0;
	INT flag = 0;
	FILE *fp = NULL;
	CHAR filename[DIRSIZE];
	CHAR curPath[DIRSIZE];
	U8 data[TEMPLATES_SIZE];

	memset(filename, 0, sizeof(filename));
	memset(curPath, 0, sizeof(curPath));
	//open path
	if(!Write_file('t', curPath))
	{
		return FAILURE;
	}
	//Output to file
	switch(model)
	{
	case 0:
		input_info(&userID);
		DebugWin(win1, 0);
		mvwprintw(win, 18, 2, "Please input index(0~9):");
		wclrtoeol(win);
		mvwscanw(win, 18, 26, "%d", &index);
		fflush(stdin);
		mvwprintw(win, 18, 2, "Please input flag[0 or 1]:");
		wclrtoeol(win);
		mvwscanw(win, 18, 28, "%d", &flag);
		fflush(stdin);
		memset(data, 0, sizeof(data));
		if(ReadTemplates(userID, index, flag, data))
		{
			sprintf(filename, "%d_%d", userID, index);
			if(NULL == (fp = fopen(filename, "wb")))
			{
				mvwprintw(win1, 1, 1, "new file err...%s:%d:%s", __FILE__, __LINE__,  __func__);
				DebugWin(win1, 2);
				return FAILURE;
			}
			fwrite(data, sizeof(data), 1, fp);
			fclose(fp);
		}
		break;
	case 1:
		//all templates
		sprintf(filename, "AllTemplates");
		if(NULL == (fp = fopen(filename, "wb"))) //open file
		{
			mvwprintw(win1, 1, 1, "new file err...%s:%d:%s", __FILE__, __LINE__,  __func__);
			DebugWin(win1, 2);
			return FAILURE;
		}
		while(1)
		{
			memset(data, 0, sizeof(data));
			if(ReadAllTemplates(data))
			{
				fwrite(data, sizeof(data), 1, fp);
			}
			else
			{
				break;
			}
		}
		fclose(fp);
		break;
	default :
		mvwprintw(win1, 1, 1, "model err");
		DebugWin(win1, 2);
		break;
	}
	mvwprintw(win1, 1, 1, "Templates File write OK!");
	DebugWin(win1, 2);

	if(chdir(curPath))
	{
		mvwprintw(win1, 1, 1, "chdir err...%s:%d:%s", __FILE__, __LINE__,  __func__);
		DebugWin(win1, 2);
		return FAILURE;
	}
	return SUCCESS;
}

INT WL_FILE(VOID)
{
	FILE *fp = NULL;
	CHAR filename[DIRSIZE];
	CHAR curPath[DIRSIZE];
	tLog user;

	memset(curPath, 0, sizeof(curPath));
	//open path
	if(!Write_file('l', curPath))
	{
		return FAILURE;
	}

	//Output to file
	while(1)
	{
		if(ReadAllLogs(((INT *)(&user.userID)), &user.Event, &user.verified, &user.Date,
				&user.Time, user.Reserved))
		{
			memset(filename, 0, sizeof(filename));
			sprintf(filename, "%d", user.userID);
			if(NULL == (fp = fopen(filename, "wb")))
			{
				mvwprintw(win1, 1, 1, "new file err...%s:%d:%s", __FILE__, __LINE__,  __func__);
				DebugWin(win1, 2);
				return FAILURE;
			}
			fwrite(&user, sizeof(tLog), 1, fp);
			fclose(fp);
		}
		else
		{
			break;
		}
	}

	mvwprintw(win1, 1, 1, "Logs File write OK!");
	DebugWin(win1, 2);

	if(chdir(curPath))
	{
		mvwprintw(win1, 1, 1, "chdir err...%s:%d:%s", __FILE__, __LINE__,  __func__);
		DebugWin(win1, 2);
		return FAILURE;
	}
	return SUCCESS;
}

U32 Read_FILE(U8 *data, CHAR *path)
{
	U32 fsize = 0;
	FILE *fp = NULL;
	U8 *buff = NULL;

	if(NULL == (fp = fopen(path, "rb+")))
	{
		mvwprintw(win1, 1, 1, "FILE: NOT_FIND");
		DebugWin(win1, 2);
		return FAILURE;
	}
	if(-1 == fseek(fp, 0, SEEK_END))
	{
		mvwprintw(win1, 1, 1, "fseek err...%s:%d:%s", __FILE__, __LINE__,  __func__);
		DebugWin(win1, 2);
		return FAILURE;
	}
	fsize = ftell(fp);
	if(-1 == fseek(fp, 0, SEEK_SET))
	{
		mvwprintw(win1, 1, 1, "fseek err...%s:%d:%s", __FILE__, __LINE__,  __func__);
		DebugWin(win1, 2);
		return FAILURE;
	}
	buff = zk_malloc(fsize);
	//start print
	if(fread(buff, fsize, 1, fp))
	{
		if(DEBUG)
		{
			mvwprintw(win1, 1, 1, "Read  File OK!");
			DebugWin(win1, 2);
		}
	}
	memcpy(data, buff, fsize);

	fclose(fp);
	fp = NULL;
	if(buff != NULL)
	{
		zk_free(buff);
		buff = NULL;
	}
	return fsize;
}

INT RT_FILE(U8 *data, CHAR *filename)
{
	CHAR *path = NULL;

	path = zk_malloc(DIRSIZE);
	sprintf(path, "./Templates/%s", filename);
	if(!Read_FILE(data, path))
	{
		return FAILURE;
	}
	if(path != NULL)
	{
		zk_free(path);
		path = NULL;
	}
	return SUCCESS;
}

INT ViewData(VOID)
{
	INT y = 1;
	INT x = 1;
	mvwprintw(win2, y++, x, "%-10s%-13s%s", "DATA", "PATH", "EXPLAIN");
	mvwprintw(win2, y++, x, "%-10s%-13s", "user","./User/");
	mvwprintw(win2, y++, x, "%-10s%-13s","template", "./Templates/");
	mvwprintw(win2, y++, x, "%-10s%-13s","logs", "./Logs/");
	mvwprintw(win2, y++, x, "%-10s%-13s","debug.log", "./");
	touchwin(win2);
	wrefresh(win2);
	werase(win2);
	return SUCCESS;
}


INT AutoDubug(VOID)
{
	INT value = -1;
	INT ret = -1;
	INT index = 0;
	INT Year = 0;
	INT Month = 0;
	INT Day = 0;
	INT Hour = 0;
	INT Minute = 0;
	INT Second = 0;
	INT width = 0;
	INT height = 0;

	INT userID;
	CHAR name[8];
	CHAR password[5];
	U8 privilege;
	U8 figerprintNum;
	U8 Card[5];
	U16 secLevel;
	U32 PIN2;
	U8 *data = NULL;
	memset(Card, 0, sizeof(Card));

	DebugFile_init();
	//start dubeg
	mvwprintw(win1, 1, 1, "Please press figerprint!(3 times) >>>");
	DebugWin(win1, 0);
	ret = EnrollUserByScan(1001);
	if(ret <= 0)
	{
		fprintf(Fp, "[01]--->EnrollUserBySan ...err\r\n");
		return FAILURE;
	}
	fprintf(Fp, "[01]--->EnrollUserByScan.....OK!\r\n");
	mvwprintw(win1, 1, 1, "[01]--->EnrollUserByScan.....OK!");
	mvwprintw(win1, 2, 1, "Running >>>[02]--->EnrollTemplateByImage");
	DebugWin(win1, 1);
	mvwprintw(win1, 1, 1, "Please press figerprint! >>>");
	DebugWin(win1, 1);
	mvwprintw(win1, 1, 1, "Please wait a moment, data is recving ...");
	DebugWin(win1, 0);
	data = zk_malloc(IMAGE_SIZE);
	ret = GetFingerImage(&width, &height, data);
	if(ret <= 0)
	{
		fprintf(Fp, "[02-1]--->GetFingerImage.....OK!\r\n");
		return FAILURE;
	}
	mvwprintw(win1, 1, 1, "Please wait a moment, data is sending ...");
	DebugWin(win1, 0);
	ret = EnrollTemplateByImage(1002, data, width * height);
	if(data != NULL)
	{
		zk_free(data);
		data = NULL;
	}
	if(ret <= 0)
	{
		fprintf(Fp, "[02-2]--->EnrollTemplateByImage ...err\r\n");
		return FAILURE;
	}
	fprintf(Fp, "[02]--->EnrollTemplateByImage.....OK!\r\n");
	mvwprintw(win1, 1, 1, "[02]--->EnrollTemplateByImage.....OK!");
	mvwprintw(win1, 2, 1, "Running >>>[03]--->GetFingerImage");
	DebugWin(win1, 1);
	data = zk_malloc(IMAGE_SIZE);
	mvwprintw(win1, 1, 1, "Please press figerprint! >>>");
	DebugWin(win1, 1);
	mvwprintw(win1, 1, 1, "Please wait a moment, data is recving ...");
	DebugWin(win1, 0);
	ret = GetFingerImage(&width, &height, data);
	if(ret <= 0)
	{
		fprintf(Fp, "[03]--->GetFingerImage ...err\r\n");
		return FAILURE;
	}
	fprintf(Fp, "[03]--->GetFingerImage.....OK!\r\n");
	save_bmp(data, width, height);
	if(data != NULL)
	{
		zk_free(data);
		data = NULL;
	}
	mvwprintw(win1, 1, 1, "[03]--->GetFingerImage.....OK!");
	mvwprintw(win1, 2, 1, "Running >>>[04]--->IdentifyByImage");
	DebugWin(win1, 1);
	data = zk_malloc(IMAGE_SIZE);
	mvwprintw(win1, 1, 1, "Please press figerprint! >>>");
	DebugWin(win1, 1);
	mvwprintw(win1, 1, 1, "Please wait a moment, data is recving ...");
	DebugWin(win1, 0);
	ret = GetFingerImage(&width, &height, data);
	if(ret <= 0)
	{
		fprintf(Fp, "[04-1]--->GetFingerImage.....err\r\n");
		return FAILURE;
	}
	mvwprintw(win1, 1, 1, "Please wait a moment, data is sending ...");
	DebugWin(win1, 0);
	ret = IdentifyByImage(width * height, &userID, &index, data);
	if(ret <= 0)
	{
		fprintf(Fp, "[04-2]--->IdentifyByImage ...err\r\n");
		return FAILURE;
	}
	fprintf(Fp, "[04]--->IdentifyByImage.....OK!\r\n");
	if(data != NULL)
	{
		zk_free(data);
		data = NULL;
	}
	mvwprintw(win1, 1, 1, "[04]--->IdentifyByImage.....OK!");
	mvwprintw(win1, 2, 1, "Running >>>[05]");
	DebugWin(win1, 1);
	mvwprintw(win1, 1, 1, "Please press finger >>> ");
	DebugWin(win1, 0);
	ret = Verify(1001);
	if(ret <= 0)
	{
		fprintf(Fp, "[05]--->Verify ...err\r\n");
		return FAILURE;
	}
	fprintf(Fp, "[05]--->Verify.....OK!\r\n");
	mvwprintw(win1, 1, 1, "[05]--->Verify.....OK!");
	mvwprintw(win1, 2, 1, "Running >>>[19]--->ModifyUser");
	DebugWin(win1, 1);
	ret = ModifyUser(1003, "atao", "1234", 1, 1001, 0, 0, Card);
	if(ret <= 0)
	{
		fprintf(Fp, "[19]--->ModifyUser ...err\r\n");
		return FAILURE;
	}
	fprintf(Fp, "[19]--->ModifyUser.....OK!\r\n");
	mvwprintw(win1, 1, 1, "[19]--->ModifyUser.....OK!");
	mvwprintw(win1, 2, 1, "Running >>>[09]--->SetTime");
	DebugWin(win1, 1);
	ret = SetTime(2015, 9, 29, 17, 59, 57);
	if(ret <= 0)
	{
		fprintf(Fp, "[09]--->SetTime ...err\r\n");
		return FAILURE;
	}
	fprintf(Fp, "[09]--->SetTime.....OK!\r\n");
	mvwprintw(win1, 1, 1, "[09]--->SetTime.....OK!");
	mvwprintw(win1, 2, 1, "Running >>>[10]--->GetTime");
	DebugWin(win1, 1);
	ret = GetTime(&Year, &Month, &Day,  &Hour, &Minute, &Second);
	if(ret <= 0)
	{
		fprintf(Fp, "[10]--->GetTime ...err\r\n");
		return FAILURE;
	}
	fprintf(Fp, "[10]--->GetTime.....OK!\r\n");
	mvwprintw(win1, 1, 1, "[10]--->GetTime.....OK!");
	mvwprintw(win1, 2, 1, "Running >>>[11]--->GetStatus");
	DebugWin(win1, 1);
	ret = GetStatus();
	if(ret <= 0)
	{
		fprintf(Fp, "[11]--->GetStatus ...err\r\n");
		return FAILURE;
	}
	fprintf(Fp, "[11]--->GetStatus.....OK!\r\n");
	mvwprintw(win1, 1, 1, "[11]--->GetStatus.....OK!");
	mvwprintw(win1, 2, 1, "Running >>>[12]--->GetParameter");
	DebugWin(win1, 1);
	ret = GetParameter(0x71, &value);
	if(ret <= 0)
	{
		fprintf(Fp, "[12]--->GetParameter ...err\r\n");
		return FAILURE;
	}
	fprintf(Fp, "[12]--->GetParameter.....OK!\r\n");
	mvwprintw(win1, 1, 1, "[12]--->GetParameter.....OK!");
	mvwprintw(win1, 2, 1, "Running >>>[13]--->SetParameter");
	DebugWin(win1, 1);
	ret = SetParameter(0x30, 0x82);
	if(ret <= 0)
	{
		fprintf(Fp, "[13]--->SetParameter ...err\r\n");
		return FAILURE;
	}
	fprintf(Fp, "[13]--->SetParameter.....OK!\r\n");
	mvwprintw(win1, 1, 1, "[13]--->SetParameter.....OK!");
	mvwprintw(win1, 2, 1, "Running >>>[14]--->SaveParameter");
	DebugWin(win1, 1);
	ret = SaveParameter();
	if(ret <= 0)
	{
		fprintf(Fp, "[14]--->SaveParameter ...err\r\n");
		return FAILURE;
	}
	fprintf(Fp, "[14]--->SaveParameter.....OK!\r\n");
	mvwprintw(win1, 1, 1, "[14]--->SaveParameter.....OK!");
	mvwprintw(win1, 2, 1, "Running >>>[18]--->GetUser");
	DebugWin(win1, 1);
	ret = GetUser(1001, name, password, &secLevel, &PIN2, &privilege, &figerprintNum, Card);
	if(ret <= 0)
	{
		fprintf(Fp, "[18]--->GetUser ...err\r\n");
		return FAILURE;
	}
	fprintf(Fp, "[18]--->GetUser.....OK!\r\n");
	mvwprintw(win1, 1, 1, "[18]--->GetUser.....OK!");
	mvwprintw(win1, 2, 1, "Running >>>[17]--->ReadAllUsers");
	DebugWin(win1, 1);
	ret = WU_FILE();//wirte user file
	if(ret <= 0)
	{
		fprintf(Fp, "[17]--->ReadAllUsers ...err\r\n");
		return FAILURE;
	}
	fprintf(Fp, "[17]--->ReadAllUsers.....OK!\r\n");
	mvwprintw(win1, 1, 1, "[17]--->ReadAllUsers.....OK!");
	mvwprintw(win1, 2, 1, "Running >>>[23]--->ReadTemplates");
	DebugWin(win1, 1);
	ret = WT_FILE(0);//write templates file
	if(ret <= 0)
	{
		fprintf(Fp, "[23]--->ReadTemplates ...err\r\n");
		return FAILURE;
	}
	fprintf(Fp, "[23]--->ReadTemplates.....OK!\r\n");
	mvwprintw(win1, 1, 1, "[23]--->ReadTemplates.....OK!");
	mvwprintw(win1, 2, 1, "Running >>>[20]--->SetTemplates");
	DebugWin(win1, 5);
	data = zk_malloc(TEMPLATES_SIZE);
	if(RT_FILE(data, "1001_0"))
	{
		ret =  SetTemplates(1003, 0, data, TEMPLATES_SIZE);
		if(ret <= 0)
		{
			fprintf(Fp, "[20]--->SetTemplates ...err\r\n");
		}
		else
		{
			fprintf(Fp, "[20]--->SetTemplates.....OK!\r\n");
		}
	}
	if(data != NULL)
	{
		zk_free(data);
		data = NULL;
	}
	mvwprintw(win1, 1, 1, "[20]--->SetTemplates.....OK!");
	mvwprintw(win1, 2, 1, "Running >>>[21]--->DeleteTemplates");
	DebugWin(win1, 1);
	ret = DeleteTemplates(1001, 0, 0);
	if(ret <= 0)
	{
		fprintf(Fp, "[21]--->DeleteTemplates ...err\r\n");
		return FAILURE;
	}
	fprintf(Fp, "[21]--->DeleteTemplates.....OK!\r\n");
	mvwprintw(win1, 1, 1, "[21]--->DeleteTemplates.....OK!");
	mvwprintw(win1, 2, 1, "Running >>>[24]--->ReadAllTemplates");
	DebugWin(win1, 1);
	ret = WT_FILE(1);//write templates file
	if(ret <= 0)
	{
		fprintf(Fp, "[24]--->ReadAllTemplates ...err\r\n");
		return FAILURE;
	}
	fprintf(Fp, "[24]--->ReadAllTemplates.....OK!\r\n");
	mvwprintw(win1, 1, 1, "[24]--->ReadAllTemplates.....OK!");
	DebugWin(win1, 1);

	ret = DeleteUser(1001);
	if(ret <= 0)
	{
		fprintf(Fp, "[16]--->DeleteUser ...err\r\n");
		return FAILURE;
	}
	fprintf(Fp, "[16]--->DeleteUser.....OK!\r\n");
	mvwprintw(win1, 1, 1, "[16]--->DeleteUser.....OK!");
	mvwprintw(win1, 2, 1, "Running >>>[15]--->DeleteAllUsers");
	DebugWin(win1, 1);
	ret = DeleteAllUsers();
	if(ret <= 0)
	{
		fprintf(Fp, "[15]--->DeleteAllUsers ...err\r\n");
		return FAILURE;
	}
	fprintf(Fp, "[15]--->DeleteAllUsers.....OK!\r\n");
	mvwprintw(win1, 1, 1, "[15]--->DeleteAllUsers.....OK!");
	mvwprintw(win1, 2, 1, "Running >>>[22]--->DeleteAllTemplates");
	DebugWin(win1, 1);
	ret = DeleteAllTemplates();
	if(ret <= 0)
	{
		fprintf(Fp, "[22]--->DeleteAllTemplates ...err\r\n");
		return FAILURE;
	}
	fprintf(Fp, "[22]--->DeleteAllTemplates.....OK!\r\n");
	mvwprintw(win1, 1, 1, "[22]--->DeleteAllTemplates.....OK!");
	mvwprintw(win1, 2, 1, "Running >>>[06]--->DeleteAllLogs");
	DebugWin(win1, 1);
	ret = DeleteAllLogs();
	if(ret <= 0)
	{
		fprintf(Fp, "[06]--->DeleteAllLogs ...err\r\n");
		return FAILURE;
	}
	fprintf(Fp, "[06]--->DeleteAllLogs.....OK!\r\n");
	mvwprintw(win1, 1, 1, "[06]--->DeleteAllLogs.....OK!");
	mvwprintw(win1, 2, 1, "Running >>>[07]--->ClearDB");
	DebugWin(win1, 1);
	ret = ClearDB();
	if(ret <= 0)
	{
		fprintf(Fp, "[07]--->ClearDB ...err\r\n");
		return FAILURE;
	}
	fprintf(Fp, "[07]--->ClearDB.....OK!\r\n");
	mvwprintw(win1, 1, 1, "[07]--->ClearDB.....OK!");
	DebugWin(win1, 1);

	return SUCCESS;
}

#if 0
int read_image(char *filename, U8 *data)
{
	FILE *fp = NULL;
	U8 *buff = NULL;
	int len = 0;
	int offset = 0;

	if(NULL == (fp = fopen(filename, "rb")))
	{
		mvwprintw(win1, 1, 1, "FILE: NOT_FIND");
		DebugWin(win1, 2);
		return FAILURE;
	}
	buff = zk_malloc(IMAGE_SIZE);
	fseek(fp, 0, SEEK_END);
	len = ftell(fp);
	fseek(fp, 0, SEEK_SET);
	if(fread(buff, len, 1, fp))
	{
		mvwprintw(win1, 1, 1, "Read fingerImage OK!");
		DebugWin(win1, 2);
	}
	memcpy(&offset, buff+10, 4);
	memcpy(data, buff+offset, len - offset);

	fclose(fp);
	if(buff != NULL)
	{
		zk_free(buff);
		buff = NULL;
	}
	return SUCCESS;
}
#endif

/************************* Fail info ************************/
INT DisplayFail(INT Flag)
{
	mvwprintw(win1, 1, 1, "Fail Info :");
	switch(Flag)
	{
		case ERR_FAIL:
			mvwprintw(win1, 1, 12, "FAIL");
			break;
		case ERR_TIME_OUT:
			mvwprintw(win1, 1, 12, "TIME_OUT");
			break;
		case ERR_MEM_FULL:
			mvwprintw(win1, 1, 12, "MEM_FULL");
			break;
		case ERR_PARAM_ERROR:
			mvwprintw(win1, 1, 12, "PARAM_ERROR");
			break;
		case ERR_NOT_FIND:
			mvwprintw(win1, 1, 12, "NOT_FIND");
			break;
		case ERR_FP_LIMIT:
			mvwprintw(win1, 1, 12, "FP_LIMIT");
			break;
		case ERR_INVALID_ID:
			mvwprintw(win1, 1, 12, "INVALID_ID");
			break;
		case ERR_CANCELED:
			mvwprintw(win1, 1, 12, "CANCELED");
			break;
		case ERR_DATA_ERROR:
			mvwprintw(win1, 1, 12, "DATA_ERROR");
			break;
		case ERR_EXIST_FP:
			mvwprintw(win1, 1, 12, "EXIST_FP");
			break;
		default:
			break;
	}
	DebugWin(win1, 1);
	return SUCCESS;
}

INT Write_file(CHAR dir_flag, CHAR *curPath)
{
	CHAR *ePath = NULL;

	if(NULL == (getcwd(curPath, DIRSIZE)))
	{
		mvwprintw(win1, 1, 1, "getcwd err...%s:%d:%s", __FILE__, __LINE__,  __func__);
		DebugWin(win1, 2);
		return FAILURE;
	}
	mvwprintw(win1, 1, 1, "curPath:%s", curPath);
	DebugWin(win1, 2);

	switch(dir_flag)
	{
		case 'l':
			ePath = LOGS_DIR;
			break;
		case 'u':
			ePath = USER_DIR;
			break;
		case 't':
			ePath = TEMPLATE_DIR;
			break;
		default :
			break;
	}
	if(-1 == access(ePath, 0))
	{
	    if(-1 == mkdir(ePath, 0777))
	    {
			mvwprintw(win1, 1, 1, "mkdir err...%s:%d:%s", __FILE__, __LINE__,  __func__);
			DebugWin(win1, 2);
			return FAILURE;
	    }
	}
	if(chdir(ePath))
	{
		mvwprintw(win1, 1, 1, "chdir err...%s:%d:%s", __FILE__, __LINE__,  __func__);
		DebugWin(win1, 2);
		return FAILURE;
	}
	if(Dev_num == DEV_USB)
	{
		Recv_data();
	}
	return SUCCESS;
}






